/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile;

import com.badlogic.gdx.math.Vector2;

public enum CompassDirection {
    NORTH(0, 1, 2, 1),
    NORTH_EAST(1, 1, 4, 2),
    EAST(1, 0, 16, 5),
    SOUTH_EAST(1, -1, 128, 8),
    SOUTH(0, -1, 64, 7),
    SOUTH_WEST(-1, -1, 32, 6),
    WEST(-1, 0, 8, 3),
    NORTH_WEST(-1, 1, 1, 0);

    private final int xOffset;
    private final int yOffset;
    private final int binaryMask;
    private final int index;
    private final float distance;

    private CompassDirection(int xOffset, int yOffset, int binaryMask, int index) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.binaryMask = binaryMask;
        this.index = index;
        this.distance = (float)Math.sqrt(xOffset * xOffset + yOffset * yOffset);
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public Vector2 toVector() {
        return new Vector2(this.xOffset, this.yOffset);
    }

    public int getBinaryMask() {
        return this.binaryMask;
    }

    public int getIndex() {
        return this.index;
    }

    public float distance() {
        return this.distance;
    }

    public boolean isDiagonal() {
        return this.xOffset != 0 && this.yOffset != 0;
    }
}

